# GURPS WWII macros.

$$macro ww2templateaddl (orienteering) {{
	opt
		begin text "Chain Script" GURPSWWIIScript.chain noprint end
		$$ifdef(orienteering)
			begin text "WWII Orienteering" "$(orienteering)" noprint end
		$$endif
	end
}}

$$macro ww2gun(name, skill, malf, dtype, dmg, ss, acc, halfd, max, weight, rof, shots, st, rcl, price, tl, notes, cat, page, hold, awt)
{{
$$macrodesc("Gun macro - WWII specific, wraps around $$gun")
$$argdesc(name, "Gun name [Passed to $$gun]")
$$argdesc(skill, "List of skills for gun [Passed to $$gun]")
$$argdesc(malf, "Malfunction number [Passed to $$gun]")
$$argdesc(dtype, "Damage type (cr, imp, etc.) [Passed to $$gun]")
$$argdesc(dmg, "Damage (4d+2, etc.) [Passed to $$gun]")
$$argdesc(ss, "Snapshot [Passed to $$gun]")
$$argdesc(acc, "Accuracy [Passed to $$gun]")
$$argdesc(halfd, "Half damage distance [Passed to $$gun]")
$$argdesc(max, "Maximum distance [Passed to $$gun]")
$$argdesc(weight, "Weight (in lbs) [Passed to $$gun]")
$$argdesc(rof, "Rate of fire (optional, for example 3~) [Passed to $$gun]")
$$argdesc(shots, "Number of shots [Passed to $$gun]")
$$argdesc(st, "Minimum ST required [Passed to $$gun]")
$$argdesc(rcl, "Recoil penalty [Passed to $$gun]")
$$argdesc(price, "Price (in $). To indicate multiple prices, use the form \"Early 1900's,35;Modern,300\" [Passed to $$gun]")
$$argdesc(tl, "Minimum TL [Passed to $$gun]")
$$argdesc(notes, "Extra notes [Passed to $$gun]")
$$argdesc(cat: cat, "Additional categories [Passed to $$gun]")
$$argdesc(page, "Page reference [Passed to $$gun]")
$$argdesc(hold, "Holdout modifier")
$$argdesc(awt, "Ammo Weight")

	$$scan(st, "([0-9]*)([A-Z]*)", stnum, stletter)

	$$ifnull(stletter)
		$$gun($(name), $(skill), $(malf), $(dtype), $(dmg), $(ss), $(acc), $(halfd), $(max), $(weight), $(rof), $(shots), $(st), $(rcl), $(price), $(tl), $(notes), $(cat), $(page))
	$$else
		$$gun($(name), $(skill), $(malf), $(dtype), $(dmg), $(ss), $(acc), $(halfd), $(max), $(weight), $(rof), $(shots), , $(rcl), $(price), $(tl), $(notes), $(cat), $(page))
	$$endif
		opt
			$$ifdef(stletter) text ST "??$(st)" $$endif
			$$ifdef(hold) text Hold "??$(hold)" $$endif
			$$ifdef(awt) text AWt "??$(awt)" $$endif
		end
	
}}

$$macro ww2grenade(name, type, dmg, weight, fuse, price, tl, country, malf, hold, page)
{{
	$$grenade($(name), $(type), $(dmg), $(weight), $(fuse), $(price), $(tl), $(country))
		opt
			$$ifdef(malf) text Malf "??$(malf)" $$endif
			$$ifdef(hold) text Hold "??$(hold)" $$endif
			$$ifdef(page) begin text "Page" "$(page)" noprint end $$endif
		end
}}

$$macro ww2riflegrenade(name, skill, malf, dtype, dmg, ss, acc, halfd, max, weight, rof, shots, st, rcl, price, tl, notes, cat, page, hold, fuse)
{{
$$macrodesc("Rifle Grenade macro - WWII specific, wraps around $$gun")
$$argdesc(name, "Gun name [Passed to $$gun]")
$$argdesc(skill, "List of skills for gun [Passed to $$gun]")
$$argdesc(malf, "Malfunction number [Passed to $$gun]")
$$argdesc(dtype, "Damage type (cr, imp, etc.) [Passed to $$gun]")
$$argdesc(dmg, "Damage (4d+2, etc.) [Passed to $$gun]")
$$argdesc(ss, "Snapshot [Passed to $$gun]")
$$argdesc(acc, "Accuracy [Passed to $$gun]")
$$argdesc(halfd, "Half damage distance [Passed to $$gun]")
$$argdesc(max, "Maximum distance [Passed to $$gun]")
$$argdesc(weight, "Weight (in lbs) [Passed to $$gun]")
$$argdesc(rof, "Rate of fire (optional, for example 3~) [Passed to $$gun]")
$$argdesc(shots, "Number of shots [Passed to $$gun]")
$$argdesc(st, "Minimum ST required [Passed to $$gun]")
$$argdesc(rcl, "Recoil penalty [Passed to $$gun]")
$$argdesc(price, "Price (in $). To indicate multiple prices, use the form \"Early 1900's,35;Modern,300\" [Passed to $$gun]")
$$argdesc(tl, "Minimum TL [Passed to $$gun]")
$$argdesc(notes, "Extra notes [Passed to $$gun]")
$$argdesc(cat: cat, "Additional categories [Passed to $$gun]")
$$argdesc(page, "Page reference [Passed to $$gun]")
$$argdesc(hold, "Holdout modifier")
$$argdesc(fuse, "Fuse")

	$$gun($(name), $(skill), $(malf), $(dtype), $(dmg), $(ss), $(acc), $(halfd), $(max), $(weight), $(rof), $(shots), $(st), $(rcl), $(price), $(tl), $(notes), $(cat), $(page))
	opt
		$$ifdef(hold) text Hold "??$(hold)" $$endif
		$$ifdef(fuse) text Fuse "??$(fuse)" $$endif
	end
	
}}

$$macro ww2mine(name, weight, price, cat, notes, tl, page, damage, fuse)
{{
$$macrodesc("Mine macro - WWII specific, wraps around $$equip")
$$argdesc(name, "Name of equipment")
$$argdesc(weight, "Weight (optional, in lbs). If omitted, weight is 0")
$$argdesc(price, "Price (in $). To indicate multiple prices, use the form \"Early 1900's,35;Modern,300\"")
$$argdesc(cat: cat, "Equipment category (optional)")
$$argdesc(notes, "Any extra notes (optional). For example, number of hands required, etc.")

	$$equip($(name), $(weight), $(price), $(cat), $(notes), $(tl), "^n (^o`Damage`)^x|dquan(`Quantity`,1)|", "^n ($(damage))", $(page))
	opt
		$$ifdef(damage) begin text Damage "??$(damage)" noprint end $$endif
		$$ifdef(fuse) text Fuse "??$(fuse)" $$endif
	end

}}